import numpy as np
from realCh import *

config = {
    'eqs': {
        'firOn': False,
        'dfeOn': False,
        'firDfeOn': True,
        'viterbiOn': False,
        'fwdBwdOn': False,
        'fwdOn': False,
        'neqOn': False,
        'mod': 'pam4',
        'snrList': np.arange(50, 10, -2),
        #'chSBR': [1, 0.4, 0.2, 0.1],
        #'eqSBR': [1, 0.4, 0.2, 0.1],
        'chSBR': sbr7dB_vari1,
        'eqSBR': sbr7dB,
        'dataSize': 1e7,
        'noiseFlag': 1,
        # For FFE
        'firTapNumForFir': 24,
        # For DFE
        'dfeTapNumForDfe': None,
        # For FIR+DFE
        'firTapNumForFirDfe': 24,
        'dfeTapNumForFirDfe': None,
        'firMaxTapForFirDfe': 5,
        # For Viterbi
        'blockSizeList': [100],
        # For FwdBwd
        'fwdBwdLen': 10,
        # For Fwd
        'FwdLen': 5,
        # For N-EQ
        'modelFileList': ['./results/fw_isi0_in12n64/nEQ_pam4_20dB_simp1_mse.pt'],
        'inSize': 12,
        'outSize': 1,
    },

    'prune': {
        'modelFile': './results/export/isi7dB_snrsweep_3010_TRAIN/nEQ_pam4_18dB_simp1_crossEntropy.pt',
        'pruneRatio': 0.1,
        'numIterPrune': 20,
        'numFineTune': 12,
        'mod': 'pam4',
        'chSBR': sbr7dB,
        'batchSize': 8192,
        'dataSizeTrain': 1e6,
        'dataSizeValid': 1e6,
        'snrValid': 18,
        'snrTrain': 18,
        'noiseFlag': 1,
        'inSize': 12,
        'outSize': 1,
        'lossFn': 'crossEntropy',
        'lr': 1e-3,

        
    },

    'train': {
        'selTrainDataList': [1],					# 0: FwdBwd data // 1: True data
        # crossEntropy // manualCrossEntropy // mse
        'lossFnList': ['crossEntropy'],
        'useFwdBwdNeuralEq': True, 				# False : using FC neural EQ
        'mod': 'pam4',
        'snrTrainList': np.arange(30, 10, -2),
        'chSBR': sbr7dB,
        'eqSBR': sbr7dB,
        'dataSizeTrain': 1e6,
        'dataSizeValid': 1e6,
        'dataSizeTest': 1e6,
        'snrValid': 20,
        'snrTest': 20,
        'onTheFly': True,
        'noiseFlag': 1,
        'plotLoss': True,
		'trainSnrVariation': False,

		'delayOffset': None,
        'usePrunedNeuralEq': False,
        'prunedModelFile': './results/isi0_1_PRUNE/nEq_pam4_prune6.pt',

        'forceTrainIn': False,
        'mismatchSNR': None,
        # Neq Params
        'inSize': 12,
        'outSize': 1,
        'N': 32,     # 32 is optimal
        'hiddenStage': 2,
        # Train Params
        'numEpoch': 2000,
        'batchSize': 8192,
        'lr': 1e-3,
        'weightDecay': 0,
        'evalFreq': 10,

    },

    'eval': {
        'modelFileList': [
                #'./results/export/isi7dB_snrsweep_3010_TRAIN/nEQ_pam4_18dB_simp1_crossEntropy.pt',
				'./results/export/isi7dB_PRUNE/nEq_pam4_prune9.pt',
                ],
        'mod': 'pam4',
        'chSBR': sbr7dB_vari1,
        'dataSizeTrain': 1e7,
        'dataSizeValid': 1e7,
        'dataSizeTest': 1e7,
        'snrValid': 20,
        'snrTrain': 20,
        'snrTestList': np.arange(50,10,-2),
        'noiseFlag': 1,

        # Fine tune params
        'finetune': False,
        'lossFn': 'crossEntropy',
        'numEpoch': 100,
        'batchSize': 8192,
        'lr': 1e-3,
        'weightDecay': 0,
        'evalFreq': 10,
        'inSize': 12,
        'outSize': 1,
    },

    'pruneAnalysis':{
        'modelFileList':[
                    './results/isi0_1_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_2_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_3_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_4_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_5_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_6_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_7_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_9_PRUNE/nEq_pam4_prune6.pt',
        ],
        'threshold': 0
    }


}
